% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DE_functions.R
\name{voom_fit_treat}
\alias{voom_fit_treat}
\title{return DGEList containing vfit by limma::voom (if normalize = TRUE) and
tfit by limma::treat}
\usage{
voom_fit_treat(
  dge,
  group_col,
  target_group,
  normalize = TRUE,
  group = FALSE,
  lfc = 0,
  p = 0.05,
  batch = NULL,
  summary = TRUE,
  ...
)
}
\arguments{
\item{dge}{DGEList object for DE analysis, including expr and samples info}

\item{group_col}{character, column name of coldata to specify the DE comparisons}

\item{target_group}{pattern, specify the group of interest, e.g. NK}

\item{normalize}{logical, if the expr in data is raw counts needs to be normalized}

\item{group}{logical, TRUE to separate samples into only 2 groups:
`target_group`` and 'Others'; FALSE to set each level as a group}

\item{lfc}{num, cutoff of logFC for DE analysis}

\item{p}{num, cutoff of p value for DE analysis and permutation test if
feature_selection = "rankproduct"}

\item{batch}{vector of character, column name(s) of coldata to be treated as
batch effect factor, default NULL}

\item{summary}{logical, if to show the summary of DE analysis}

\item{...}{omitted}
}
\value{
A DGEList containing vfit and tfit
}
\description{
return DGEList containing vfit by limma::voom (if normalize = TRUE) and
tfit by limma::treat
}
