% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lm_sig.R
\name{get_lm_sig}
\alias{get_lm_sig}
\title{Extract specific subset markers from LM7 or/and LM22}
\usage{
get_lm_sig(lm7.pattern, lm22.pattern, ...)
}
\arguments{
\item{lm7.pattern}{character string containing a regular expression,
to be matched in the given subsets in LM7}

\item{lm22.pattern}{character string containing a regular expression,
to be matched in the given subsets in LM22}

\item{...}{params for function \code{\link[=grep]{grep()}}}
}
\value{
A GeneSet or GeneSetCollection for matched subsets in LM7 and/or LM22
}
\description{
Extract markers for subsets matched to the given pattern from LM7/LM22, and
save the matched genes in 'GeneSet' class object, if both pattern are
provided, the output would be a 'GeneSetCollection' class object with
setName: LM7, LM22.
}
\examples{
data("lm7", "lm22")
get_lm_sig(lm7.pattern = "NK", lm22.pattern = "NK cells")
}
