% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scones.R
\name{snp_test}
\alias{snp_test}
\title{Calculate genotype-phhenotype associations}
\usage{
snp_test(gwas, covars, score, family, link)
}
\arguments{
\item{gwas}{A SnpMatrix object with the GWAS information.}

\item{covars}{A data frame with the covariates. It must contain a column 
'sample' containing the sample IDs, and an additional columns for each 
covariate.}

\item{score}{Association score to measure association between genotype and 
phenotype. Possible values: chi2 (default), glm.}

\item{family}{A string defining the generalized linear model family. This 
should match one of "binomial", "poisson", "gaussian" or "gamma". See
\link[snpStats]{snp.rhs.tests} for details.}

\item{link}{A string defining the link function for the GLM. This should
match one of "logit", "log", "identity" or "inverse". See 
\link[snpStats]{snp.rhs.tests} for details.}
}
\value{
A named vector with the association scores.
}
\description{
Calculate the association between genotypes and a phenotype,
adjusting by covariates.
}
\keyword{internal}
