% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz.R
\name{plot_ideogram}
\alias{plot_ideogram}
\title{Ideogram of SConES results.}
\usage{
plot_ideogram(gwas, net, covars = data.frame(), genome = "hg19")
}
\arguments{
\item{gwas}{A SnpMatrix object with the GWAS information.}

\item{net}{An igraph network that connects the SNPs.}

\item{covars}{A data frame with the covariates. It must contain a column 
'sample' containing the sample IDs, and an additional columns for each 
covariate.}

\item{genome}{Abbreviations of the genome to use: hg19 for human (default), 
mm10 for mouse, etc.}
}
\value{
A circular ideogram, including the manhattan plot, and the
interactions between the selected SNPs.
}
\description{
Create a circular ideogram of the a network results using the
circlize package (Gu et al., 2014).
}
\references{
Gu, Z., Gu, L., Eils, R., Schlesner, M., & Brors, B. (2014).
circlize Implements and enhances circular visualization in R. Bioinformatics
(Oxford, England), 30(19), 2811-2. 
\url{https://doi.org/10.1093/bioinformatics/btu393}
}
