% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{Marr-class}
\alias{Marr-class}
\title{the Marr class}
\value{
\code{MarrSamplepairs} returns the distribution of
percent reproducible  features (column-wise) per sample pair,
\code{MarrFeatures} returns the  distribution of percent reproducible
sample pairs (row-wise) per feature,
\code{MarrSamplepairsfiltered} returns the percent of reproducible
features based on a threshold value and
\code{MarrFeaturesfiltered} returns the percent of reproducible
sample pairs based on a threshold value
}
\description{
Objects of this class store
needed information to work with a
Marr object
}
\section{Slots}{

\describe{
\item{\code{MarrSamplepairs}}{Marr sample pairs}

\item{\code{MarrFeatures}}{Marr features}

\item{\code{MarrSamplepairsfiltered}}{Marr sample pairs post filtering}

\item{\code{MarrFeaturesfiltered}}{Marr metabolites post filtering}

\item{\code{MarrData}}{Original data object passed to \code{Marr}}

\item{\code{MarrPSamplepairs}}{Value of \code{pSamplepairs} argument passed 
to \code{Marr}}

\item{\code{MarrPFeatures}}{Value of \code{pFeatures} argument passed to \code{Marr}}

\item{\code{MarrAlpha}}{Value of \code{alpha} argument passed to \code{Marr}}

\item{\code{MarrFeatureVars}}{Value of \code{featureVars} passed to \code{Marr}. NULL
if \code{featureVars} was left blank}
}}

\examples{
data <- matrix(rnorm(2400), nrow=200, ncol=12)
data_Marr <- Marr(object = data, pSamplepairs=0.75,
                  pFeatures=0.75, alpha=0.05)

}
