% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-pileupPixels.R
\name{pileupPixels}
\alias{pileupPixels}
\alias{pileupPixels,GInteractions,character,numeric-method}
\title{Pileup Hi-C pixels}
\usage{
pileupPixels(
  x,
  files,
  binSize,
  buffer = 5,
  removeShort = TRUE,
  minPairDist = 0,
  normalize = TRUE,
  FUN = sum,
  nBlocks = 5,
  verbose = TRUE,
  BPPARAM = bpparam(),
  ...
)

\S4method{pileupPixels}{GInteractions,character,numeric}(
  x,
  files,
  binSize,
  buffer = 5,
  removeShort = TRUE,
  minPairDist = 0,
  normalize = TRUE,
  FUN = sum,
  nBlocks = 5,
  verbose = TRUE,
  BPPARAM = bpparam(),
  ...
)
}
\arguments{
\item{x}{GInteractions object containing interactions
to extract from Hi-C files. These should be pixels
of a single `binSize` in width.}

\item{files}{Character file paths to `.hic` files.}

\item{binSize}{Integer (numeric) describing the
resolution (range widths) of the paired data.}

\item{buffer}{Integer indicating the
buffer size, or number of pixels}

\item{removeShort}{Boolean, whether to remove
short pairs (Default) or not.}

\item{minPairDist}{Pairs with a distance less than
or equal to this value will be filtered out.}

\item{normalize}{Boolean, whether to normalize
the aggregated values to the number of interactions
(after filtering out short pairs - if applicable).}

\item{FUN}{Function to use for aggregating.}

\item{nBlocks}{Number of blocks for block-processing
arrays. Default is 5. Increase this for large
datasets. To read and process all data at once, set
this value to 1.}

\item{verbose}{Boolean (TRUE or FALSE) describing
whether to report block-processing progress.}

\item{BPPARAM}{Parallelization params (passed to
`BiocParallel::bplapply()`). Default is the result
of `BiocParallel::bpparams()`. Parallel processing
is not available when `by=interactions`.}

\item{...}{Additional arguments passed to 
`pullHicMatrices()`.}
}
\value{
A DelayedMatrix of aggregated
 counts.
}
\description{
pileupPixels optionally removes short interactions
that intersect the diagonal before extracting
then aggregating square regions around each
pixel from Hi-C files. This is also known
as aggregate peak analysis (APA)
}
\details{
Note that pair distance filtering is done after
expanding interactions to matrices.
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFile <- marinerData::LEUK_HEK_PJA30_inter_30.hic()
names(hicFile) <- "WT"

## Loops
loops <-
    WT_5kbLoops.txt() |>
    setNames("WT") |>
    read.table(header=TRUE, nrows=1000) |>
    as_ginteractions(keep.extra.columns=FALSE) |>
    assignToBins(binSize=5e3)

## Removes the "chr" prefix for compatibility
## with the preprocessed hic files
GenomeInfoDb::seqlevelsStyle(loops) <- 'ENSEMBL'

## APA
mat <- pileupPixels(
    x=loops,
    files=hicFile,
    binSize=5e3,
    minPairDist=50e3,
    normalize=FALSE
)


}
