% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PowerEval.R
\name{powerEval}
\alias{powerEval}
\title{Power evaluation for MeRIP-seq data under various study designs.}
\usage{
powerEval(
  Input.file,
  IP.file,
  BamDir,
  annoDir,
  variable,
  bam_factor,
  nsim = 10,
  N.reps = c(2, 3, 5),
  depth_factor = c(1, 2, 5),
  thres = c(0.01, 0.05, 0.1, 0.2),
  Test_method = "TRESS"
)
}
\arguments{
\item{Input.file}{A vector containing the name of BAM files of input samples.}

\item{IP.file}{A vector containing the name of BAM files of IP samples.}

\item{BamDir}{A character stating the directory path of all .BAM files.}

\item{annoDir}{A character stating the directory path of the ".sqlite" file for annotation.}

\item{variable}{A vector indicating the experimental conditions of all samples.}

\item{bam_factor}{A numrical value indicating the ratio of provided data to the whole genome data. Default is 0.05.}

\item{nsim}{An integer indicating the number of iterations to simulate under each scenario. Default is 10.}

\item{N.reps}{A vector of integers indicating the numbers of replicates to simulate, in both groups. Default is c(2,3,5).}

\item{depth_factor}{A vector of numerical values indicating how much sequencing depth of the provided data will be increased in simulations. For example, 2 means doubling the original sequencing depth. Default is c(1,2,5).}

\item{thres}{A vector of numerical values indicating the p-value thresholds used in power calculation. Default is c(0.01, 0.05, 0.1, 0.2).}

\item{Test_method}{A character indicating which DMR calling method to use. Options are "TRESS" and "exomePeak2". Default is "TRESS".}
}
\value{
A list of calculated power measurements that will be used as the input of functions \code{\link{writeToxlsx}}, \code{\link{writeToxlsx_strata}}, \code{\link{plotAll}}, \code{\link{plotRes}}, \code{\link{plotAll_Strata}}, and \code{\link{plotStrata}}.
Measurements include:
\item{FDR}{The ratio of number of false positives to the number of positive discoveries.}
\item{FDC}{The ratio of number of false positives to the number of true positives.}
\item{Power}{Statistical power.}
\item{Precision}{The ratio of number of true positives to the number of positive discoveries.}
}
\description{
This function conducts simulations with various user-defined study design parameters, including but not limited to
sample size, sequencing depth, and testing method. Users will need to provide either partial or whole-genome MeRIP-seq data
for parameter estimation purposes.
}
\examples{
\dontrun{
library(magpieData)
library(magpie)
### Get the example data
BAM_path <- getBAMpath()
### Call PowerEval()
power.test <- powerEval(
    Input.file = c("Ctrl1.chr15.input.bam", "Ctrl2.chr15.input.bam", "Case1.chr15.input.bam", "Case2.chr15.input.bam"),
    IP.file = c("Ctrl1.chr15.ip.bam", "Ctrl2.chr15.ip.bam", "Case1.chr15.ip.bam", "Case2.chr15.ip.bam"),
    BamDir = BAM_path,
    annoDir = paste0(BAM_path, "/hg18_chr15.sqlite"),
    variable = rep(c("Ctrl", "Trt"), each = 2),
    bam_factor = 0.03,
    nsim = 10,
    N.reps = c(2, 3, 5, 7),
    depth_factor = c(1, 2),
    thres = c(0.01, 0.05, 0.1),
    Test_method = "TRESS"
)
}
}
