% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeToxlsx_strata.R
\name{writeToxlsx_strata}
\alias{writeToxlsx_strata}
\title{Write power evaulation results of four strata under all sample size scenarios to a .xlsx file.}
\usage{
writeToxlsx_strata(pl, file)
}
\arguments{
\item{pl}{A list produced by \code{\link{powerEval}}.}

\item{file}{A character indicating the name of the output .xlsx file.}
}
\value{
It outputs a .xlsx file including FDR, FDC, power, and precision under the original sequencing depth and various sample sizes
and input stratas.
}
\description{
This function writes power evaulation results of four strata to a .xlsx file. Only results from the original sequencing depth are saved.
    Here, strata are determined by mean input control levels of simulated data.
}
\examples{

library(magpie)
### Main function
power.test <- quickPower(dataset = "GSE46705", test_method = "TRESS")

### write out .xlsx
writeToxlsx_strata(power.test, file = "test_strata_TRESS.xlsx")

}
