% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProtein.R
\name{plotProtein}
\alias{plotProtein}
\title{Display protein domains}
\usage{
plotProtein(
  gene,
  refSeqID = NULL,
  proteinID = NULL,
  domainAlpha = 0.9,
  showLegend = FALSE,
  bgBorderCol = "black",
  axisTextSize = c(1, 1),
  roundedRect = TRUE,
  domainBorderCol = "black",
  showDomainLabel = TRUE,
  domainLabelSize = 0.8,
  titleSize = c(1.2, 1),
  legendTxtSize = 1,
  legendNcol = 1
)
}
\arguments{
\item{gene}{HGNC symbol for which protein structure to be drawn.}

\item{refSeqID}{RefSeq transcript identifier for \code{gene} if known.}

\item{proteinID}{RefSeq protein identifier for \code{gene} if known.}

\item{domainAlpha}{Default 1}

\item{showLegend}{Default TRUE}

\item{bgBorderCol}{Default "black". Set to NA to remove.}

\item{axisTextSize}{text size x and y tick labels. Default c(1,1).}

\item{roundedRect}{Default TRUE. If `TRUE` domains are drawn with rounded corners. Requires \code{berryFunctions}}

\item{domainBorderCol}{Default "black". Set to NA to remove.}

\item{showDomainLabel}{Default TRUE}

\item{domainLabelSize}{text size for domain labels. Default 0.8}

\item{titleSize}{font size for title and subtitle. Default c(1.2, 1)}

\item{legendTxtSize}{Text size for legend. Default 0.8}

\item{legendNcol}{Default 1}
}
\description{
Display protein domains
}
\examples{
par(mfrow = c(2, 1))
plotProtein(gene = "KIT")
plotProtein(gene = "DNMT3A")
}
