% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisticBubblePlot.R
\name{gisticBubblePlot}
\alias{gisticBubblePlot}
\title{Plot gistic results as a bubble plot}
\usage{
gisticBubblePlot(
  gistic = NULL,
  color = NULL,
  markBands = NULL,
  fdrCutOff = 0.1,
  log_y = TRUE,
  txtSize = 3
)
}
\arguments{
\item{gistic}{an object of class \code{GISTIC} generated by \code{readGistic}}

\item{color}{colors for Amp and Del events.}

\item{markBands}{any cytobands to label. Can be cytoband labels, or number of top bands to highlight. Default top 5 lowest q values.}

\item{fdrCutOff}{fdr cutoff to use. Default 0.1}

\item{log_y}{log10 scale y-axis (# genes affected). Default TRUE}

\item{txtSize}{label size for bubbles.}
}
\value{
Nothing
}
\description{
Plots significantly altered cytobands as a function of number samples in which it is altered and number genes it contains. Size of each bubble is according to -log10 transformed q values.
}
\examples{
all.lesions <- system.file("extdata", "all_lesions.conf_99.txt", package = "maftools")
amp.genes <- system.file("extdata", "amp_genes.conf_99.txt", package = "maftools")
del.genes <- system.file("extdata", "del_genes.conf_99.txt", package = "maftools")
scores.gistic <- system.file("extdata", "scores.gistic", package = "maftools")
laml.gistic = readGistic(gisticAllLesionsFile = all.lesions, gisticAmpGenesFile = amp.genes, gisticDelGenesFile = del.genes, gisticScoresFile = scores.gistic)
gisticBubblePlot(gistic = laml.gistic, markBands = "")
}
