% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisticObject.R
\docType{class}
\name{GISTIC-class}
\alias{GISTIC-class}
\alias{GISTIC}
\title{Class GISTIC}
\description{
S4 class for storing summarized MAF.
}
\section{Slots}{

\describe{
\item{\code{data}}{data.table of summarized GISTIC file.}

\item{\code{cnv.summary}}{table containing alterations per sample}

\item{\code{cytoband.summary}}{table containing alterations per cytoband}

\item{\code{gene.summary}}{table containing alterations per gene}

\item{\code{cnMatrix}}{character matrix of dimension n*m where n is number of genes and m is number of samples}

\item{\code{numericMatrix}}{numeric matrix of dimension n*m where n is number of genes and m is number of samples}

\item{\code{gis.scores}}{gistic.scores}

\item{\code{summary}}{table with basic GISTIC summary stats}

\item{\code{classCode}}{mapping between numeric values in numericMatrix and copy number events.}
}}

\seealso{
\code{\link{getGeneSummary}} \code{\link{getSampleSummary}} \code{\link{getCytobandSummary}}
}
