% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/loci2pathResult-methods.R
\docType{methods}
\name{getWordcloud}
\alias{getWordcloud}
\alias{getWordcloud,loci2pathResult-method}
\title{Plot word cloud using frequent terms of pathways and genes}
\usage{
getWordcloud(res, ...)

\S4method{getWordcloud}{loci2pathResult}(res, min.freq.tissue = 5,
  min.freq.gset = 5, max.words = 50)
}
\arguments{
\item{res}{query result from function query.egset.list()}

\item{\dots}{additional params}

\item{min.freq.tissue}{minimum frequency of tissue/cell to be plotted in 
the word cloud}

\item{min.freq.gset}{minimum frequency of geneset to be plotted in the 
word cloud}

\item{max.words}{maximum words to be generated}
}
\value{
empty
}
\description{
This function draw the enrichment heatmap using 
\code{wordcloud} package.
}
\examples{
result <- query(query.gr=query.gr, 
  loci=eset.list, path=biocarta)
getWordcloud(result, min.freq.tissue=2, min.freq.gset=1)
}
\keyword{cloud}
\keyword{word}
