% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_samples}
\alias{plot_samples}
\title{Informative plots to investigate samples}
\usage{
plot_samples(
  data,
  type = c("tic", "boxplot"),
  measure = "Area",
  log = TRUE,
  color = NULL
)
}
\arguments{
\item{data}{LipidomicsExperiment object.}

\item{type}{plot type, either \code{tic} or \code{boxplot}. Default is \code{tic}.}

\item{measure}{Which measure to use as intensity, usually Area,
Area Normalized or Height. Default is \code{Area}}

\item{log}{Whether values should be log2 transformed. Default is \code{TRUE}}

\item{color}{The column name of a sample annotation to be used as color}
}
\value{
A ggplot object.
}
\description{
\code{lipidr} supports two types of plots for sample quality checking.\cr\cr
\code{tic} plots a bar chart for total sample intensity.\cr\cr
\code{boxplot} plots a boxplot chart to examine the distribution of values
per sample.
}
\examples{
data(data_normalized)

plot_samples(data_normalized, type = "tic", "Area", log = TRUE)
plot_samples(data_normalized, type = "tic", "Background", log = FALSE)
plot_samples(
  data_normalized[, data_normalized$group == "QC"],
  type = "boxplot",
  measure = "Retention Time", log = FALSE
)
}
