% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statical.R
\name{run_chicane}
\alias{run_chicane}
\alias{run_chicane,linkSet-method}
\title{Run ChICANE Analysis}
\usage{
run_chicane(linkSet, ...)

\S4method{run_chicane}{linkSet}(
  linkSet,
  replicate.merging.method = "sum",
  distribution = "negative-binomial",
  include.zeros = "none",
  bait.filters = c(0, 1),
  target.filters = c(0, 1),
  distance.bins = NULL,
  multiple.testing.correction = c("bait-level", "global"),
  adjustment.terms = NULL,
  remove.adjacent = FALSE,
  temp.directory = NULL,
  keep.files = FALSE,
  maxit = 100,
  epsilon = 1e-08,
  cores = 1,
  trace = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{linkSet}{A linkSet object containing interaction data}

\item{...}{Additional arguments passed to methods}

\item{replicate.merging.method}{Method for merging replicates (default: 'sum')}

\item{distribution}{Distribution to use for modeling (default: 'negative-binomial')}

\item{include.zeros}{How to handle zero counts (default: 'none')}

\item{bait.filters}{Vector of length 2 for bait filtering thresholds (default: c(0,1))}

\item{target.filters}{Vector of length 2 for target filtering thresholds (default: c(0,1))}

\item{distance.bins}{Number of distance bins (default: NULL)}

\item{multiple.testing.correction}{Method for multiple testing correction (default: 'bait-level')}

\item{adjustment.terms}{Additional terms for model adjustment (default: NULL)}

\item{remove.adjacent}{Whether to remove adjacent fragments (default: FALSE)}

\item{temp.directory}{Directory for temporary files (default: NULL)}

\item{keep.files}{Whether to keep temporary files (default: FALSE)}

\item{maxit}{Maximum iterations for model fitting (default: 100)}

\item{epsilon}{Convergence threshold (default: 1e-8)}

\item{cores}{Number of CPU cores to use (default: 1)}

\item{trace}{Whether to print trace information (default: FALSE)}

\item{verbose}{Whether to print progress information (default: FALSE)}
}
\value{
A linkSet object with additional columns:
\itemize{
\item \code{expected} The expected number of reads linking fragments under the fitted model
\item \code{p.value} P-value for test of observed vs expected read counts
\item \code{q.value} FDR-corrected p-value
}
}
\description{
This function adapts the \code{chicane} function from the \code{ChICANE}
package to work with the \code{linkSet} object format. It runs the full method for
detecting significant interactions in capture Hi-C experiments.
}
\details{
Run ChICANE Analysis on linkSet Object
}
\examples{
# Create example data
gr1 <- GRanges(seqnames = c("chr1", "chr3", "chr3"),
               ranges = IRanges(start = c(1000, 2000, 3000), width = 100),
               strand = "+", symbol = c("BRCA1", "TP53", "NONEXISTENT"))
gr2 <- GRanges(seqnames = c("chr1", "chr2", "chr3"),
               ranges = IRanges(start = c(5000, 6000, 7000), width = 100),
               strand = "+")
ls <- linkSet(gr1, gr2, specificCol = "symbol")

# Annotate and prepare data
annotated_ls <- suppressWarnings(
  annotatePromoter(ls, genome = "hg38", upstream = 500, overwrite = TRUE)
)
annotated_ls <- countInteractibility(annotated_ls)
annotated_ls <- linkSet::pairdist(annotated_ls)

# Run analysis
result_ls <- run_chicane(
  annotated_ls, 
  replicate.merging.method = 'sum',
  bait.filters = c(0, 1),
  target.filters = c(0, 1),
  distance.bins = NULL,
  multiple.testing.correction = 'bait-level',
  verbose = TRUE
)

}
