% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/formatConverter.R
\name{baitGInteractions}
\alias{baitGInteractions}
\alias{baitGInteractions,GInteractions,GRanges,GRanges-method}
\title{Convert GInteractions to linkSet with bait annotations}
\usage{
baitGInteractions(x, geneGr, peakGr, ...)

\S4method{baitGInteractions}{GInteractions,GRanges,GRanges}(x, geneGr, peakGr, geneSymbol = NULL)
}
\arguments{
\item{x}{A GInteractions object}

\item{geneGr}{A GRanges object representing genes}

\item{peakGr}{A GRanges object representing peaks}

\item{...}{Additional arguments}

\item{geneSymbol}{A character vector with same length as geneGr or column name in mcols(geneGr) for gene symbols}
}
\value{
A linkSet object
}
\description{
Convert GInteractions with bait range and oe ranges to linkSet
}
\examples{
# Example usage:
library(GenomicRanges)
library(InteractionSet)

# Create example GRanges objects for genes and peaks
geneGr <- GRanges(seqnames = "chr1", 
                  ranges = IRanges(start = c(100, 200), end = c(150, 250)), 
                  geneSymbol = c("Gene1", "Gene2"))
peakGr <- GRanges(seqnames = "chr1", 
                  ranges = IRanges(start = c(300, 400), end = c(350, 450)))

# Create example GInteractions object
gi <- GInteractions(anchor1 = geneGr, anchor2 = peakGr)

# Convert to linkSet
linkSetObj <- baitGInteractions(gi, geneGr, peakGr, geneSymbol = "geneSymbol")

# Print the linkSet object
print(linkSetObj)
}
