% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaBySvd.R
\name{pcaBySvd}
\alias{pcaBySvd}
\title{Singular Value Decomposition for PCA analysis}
\usage{
pcaBySvd(Y = NULL, lmpDataList = NULL, nPC = min(dim(Y)))
}
\arguments{
\item{Y}{The \eqn{n \times m} matrix with \eqn{n} observations and \eqn{m} (response) variables.}

\item{lmpDataList}{A list with outcomes, design and formula, as outputted by \code{\link{data2LmpDataList}}.}

\item{nPC}{Number of Principal Components to extract.}
}
\value{
A list containing the following elements:
\describe{
\item{\code{scores}}{Scores}
\item{\code{loadings}}{Loadings}
\item{\code{eigval}}{Eigenvalues}
\item{\code{singvar}}{Singular values}
\item{\code{var}}{Explained variances}
\item{\code{cumvar}}{Cumulated explained variances}
\item{\code{original.dataset}}{Original dataset}
\item{\code{design}}{Design of the study}

}
}
\description{
Operates a Principal Component Analysis on the \code{Y} outcome/response matrix by a singular
Value Decomposition (the pre-processing involves the mean-centering of \code{Y}).
Outputs are represented with the functions \code{\link{pcaScorePlot}},
\code{\link{pcaLoading1dPlot}}, \code{\link{pcaLoading2dPlot}} and \code{\link{pcaScreePlot}}.
}
\examples{

data("UCH")

PCA.res1 <- pcaBySvd(Y = UCH$outcomes)

PCA.res2 <- pcaBySvd(lmpDataList = UCH)

identical(PCA.res1, PCA.res2)
}
