## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  prompt = TRUE,
  comment = NA
)
options(digits=4)

## ----sim----------------------------------------------------------------------
library(limpa)
set.seed(20241230)
y.peptide <- simProteinDataSet()

## ----meanNA-------------------------------------------------------------------
dim(y.peptide)
head(y.peptide$genes)
table(y.peptide$targets$Group)
mean(is.na(y.peptide$E))

## ----dpc----------------------------------------------------------------------
dpcest <- dpc(y.peptide)
dpcest$dpc
plotDPC(dpcest)

## ----dpcQuant-----------------------------------------------------------------
y.protein <- dpcQuant(y.peptide, "Protein", dpc=dpcest)

## ----plotMDS------------------------------------------------------------------
plotMDSUsingSEs(y.protein)
Group <- factor(y.peptide$targets$Group)
Group.color <- Group
levels(Group.color) <- c("blue","red")
plotMDSUsingSEs(y.protein, pch=16, col=as.character(Group.color))

## ----dpcDE--------------------------------------------------------------------
design <- model.matrix(~Group)
fit <- dpcDE(y.protein, design, plot=TRUE)

## ----eBayes-------------------------------------------------------------------
fit <- eBayes(fit)
topTable(fit, coef=2)

## ----plotProtein--------------------------------------------------------------
plotProtein(y.protein, "Protein23", col=as.character(Group.color))

## ----eval = FALSE-------------------------------------------------------------
# y.peptide <- readDIANN("Report.tsv")

## ----eval = FALSE-------------------------------------------------------------
# y.peptide <- readDIANN("Report.parquet")

## ----eval = FALSE-------------------------------------------------------------
# y.peptide <- readDIANN("Report.tsv",
#              q.columns = c("Q.Value","Lib.Q.Value","Lib.PG.Q.Value"),
#              q.cutoffs = 0.01)

## ----eval = FALSE-------------------------------------------------------------
# y.peptide <- readDIANN("Report.tsv",
#              q.columns = c("Q.Value","Global.Q.Value","Global.PG.Q.Value"),
#              q.cutoffs = 0.01)

## ----eval = FALSE-------------------------------------------------------------
# y.peptide <- filterNonProteotypicPeptides(y.peptide)

## ----eval = FALSE-------------------------------------------------------------
# y.peptide <- filterCompoundProteins(y.peptide)

## ----eval = FALSE-------------------------------------------------------------
# y.peptide <- filterSingletonPeptides(y.peptide, min.n.peptides = 2)

