% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_terminal_nodes}
\alias{get_terminal_nodes}
\title{Identify which elements of a string are terminal nodes}
\usage{
get_terminal_nodes(string)
}
\arguments{
\item{string}{A character vector of strings to check for terminal nodes}
}
\value{
A logical vector indicating which elements of the string are terminal
nodes
}
\description{
A terminal node in a taxonomy does not have any child nodes. For example, a
species is a terminal node if there are no subspecies or strains that belong
to that species. This function identifies which elements of a vector are terminal
nodes simply by checking whether that element appears as a substring in any other
element of the vector.
}
\examples{
# What does it do?
data("zeller14")
rownames(zeller14)[988:989]
get_terminal_nodes(rownames(zeller14)[988:989])
# How do I use it to keep only terminal nodes for a lefser analysis?
terminal_nodes <- get_terminal_nodes(rownames(zeller14))
zeller14sub <- zeller14[terminal_nodes, ]
# Then continue with your analysis!
}
