% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldByGene.R
\name{ldByGene}
\alias{ldByGene}
\title{Obtain LD statistics in region specified by a gene model.}
\usage{
ldByGene(
  sym = "MMP24",
  vcf = system.file("vcf/c20exch.vcf.gz", package = "ldblock"),
  flank = 1000,
  vcfSLS = "NCBI",
  genomeSLS = "hg19",
  stats = "D.prime",
  depth = 10
)
}
\arguments{
\item{sym}{A standard gene symbol for use with \code{genemodel}}

\item{vcf}{Path to a tabix-indexed VCF file}

\item{flank}{number of basepairs to flank gene model for search}

\item{vcfSLS}{seqlevelsStyle (SLS) token for VCF; will be imposed on gene
model}

\item{genomeSLS}{character tag for genome, to be used with
\code{readVcf}}

\item{stats}{passed to \code{\link[snpStats]{ld}}}

\item{depth}{passed to \code{\link[snpStats]{ld}}}
}
\value{
sparse matrix representation of selected LD statistic, as returned
by \code{\link[snpStats]{ld}}
}
\description{
Obtain LD statistics in region specified by a gene model.
}
\note{
Uses an internal function genemod4ldblock, that relies
on EnsDb.Hsapiens.v75 to get gene model.
}
\examples{
if (interactive()) {  # there is a warning owing to non-SNV present
ld1 = ldByGene(depth=150)
image(ld1[1:200,1:200], col.reg=heat.colors(120), colorkey=TRUE,
 main="SNPs in MMP24 (chr20)") 
}
}
\keyword{models}
