% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testEnrichment.R
\name{testEnrichment}
\alias{testEnrichment}
\title{testEnrichment tests for the enrichment of query in knowledgebase sets}
\usage{
testEnrichment(
  query,
  databases = NULL,
  universe = NULL,
  alternative = "greater",
  include_genes = FALSE,
  platform = NULL,
  silent = FALSE,
  mtc_by_group = TRUE,
  mtc_method = "fdr"
)
}
\arguments{
\item{query}{For array input, it is a vector of probes of interest
(e.g., significant differential methylated probes). For sequencing data
input, it expect the file name for YAME-compressed CG sets.}

\item{databases}{List of vectors corresponding to the database sets of
interest with associated meta data as an attribute to each element.
Optional. (Default: NA)}

\item{universe}{Vector of probes in the universe set containing all of
the probes to be considered in the test. If it is not provided, it will be
inferred from the provided platform. (Default: NA).}

\item{alternative}{"two.sided", "greater", or "less"}

\item{include_genes}{include gene link enrichment testing}

\item{platform}{String corresponding to the type of platform to use. Either
MM285, EPIC, HM450, or HM27. If it is not provided, it will be inferred
from the query set probeIDs (Default: NA).}

\item{silent}{output message? (Default: FALSE)}

\item{mtc_by_group}{peform multiple testing correction within 
knowledgebase groups (Default: TRUE)}

\item{mtc_method}{method for multiple test correction (default: fdr)}
}
\value{
A data frame containing features corresponding to the test estimate,
p-value, and type of test.
}
\description{
testEnrichment tests for the enrichment of query in knowledgebase sets
}
\examples{

library(SummarizedExperiment)
sesameData::sesameDataCache(data_titles=
c("MM285.tissueSignature","KYCG.MM285.chromHMM.20210210","MM285.address"))
df <- rowData(sesameData::sesameDataGet("MM285.tissueSignature"))
probes <- df$Probe_ID[df$branch == "B_cell"]
res <- testEnrichment(probes, "chromHMM", platform="MM285")
sesameData::sesameDataGet_resetEnv()

\dontrun{
# Define temporary directory and file URLs
temp_dir <- tempdir()
knowledgebase <- file.path(temp_dir, "ChromHMM.20220414.cm")
query <- file.path(temp_dir, "single_cell_10_samples.cg")
# URLs for the knowledgebase and query files
knowledgebase_url <- "https://github.com/zhou-lab/KYCGKB_mm10/raw/refs/heads/main/ChromHMM.20220414.cm"
query_url <- "https://github.com/zhou-lab/YAME/raw/refs/heads/main/test/input/single_cell_10_samples.cg"
# Download the files
download.file(knowledgebase_url, destfile = knowledgebase)
download.file(query_url, destfile = query)
# Confirm file download
list.files(temp_dir)
res = testEnrichment(query, knowledgebase)
}
}
