% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{getDBs}
\alias{getDBs}
\title{Get databases by full or partial names of the database group(s)}
\usage{
getDBs(
  group_nms,
  db_names = NULL,
  platform = NULL,
  summary = FALSE,
  allow_multi = FALSE,
  type = NULL,
  silent = FALSE
)
}
\arguments{
\item{group_nms}{database group names}

\item{db_names}{name of the database, fetech only the given databases}

\item{platform}{EPIC, HM450, MM285, ... If given, will restrict to
that platform.}

\item{summary}{return a summary of database instead of db itself}

\item{allow_multi}{allow multiple groups to be returned for}

\item{type}{numerical, categorical, default: all}

\item{silent}{no messages
each query.}
}
\value{
a list of databases, return NULL if no database is found
}
\description{
Get databases by full or partial names of the database group(s)
}
\examples{
sesameData::sesameDataCache(data_titles=
c("KYCG.MM285.chromHMM.20210210","KYCG.MM285.probeType.20210630"))
dbs <- getDBs("MM285.chromHMM")
dbs <- getDBs(c("MM285.chromHMM", "MM285.probeType"))
}
