% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KYCG_plot.R
\name{KYCG_plotBar}
\alias{KYCG_plotBar}
\title{Bar plot to show most enriched CG groups from testEnrichment}
\usage{
KYCG_plotBar(df, y = "-log10(FDR)", n = 20, order_by = "FDR", label = FALSE)
}
\arguments{
\item{df}{KYCG result data frame}

\item{y}{the column to be plotted on y-axis}

\item{n}{number of CG groups to plot}

\item{order_by}{the column by which CG groups are ordered}

\item{label}{whether to label significant bars}
}
\value{
grid plot object
}
\description{
The input data frame should have an "estimate" and
a "FDR" columns.
}
\details{
Top CG groups are determined by estimate (descending order).
}
\examples{
KYCG_plotBar(data.frame(
  estimate=runif(10,0,10), FDR=runif(10,0,1), nD=10,
  overlap=as.integer(runif(10,0,30)), group="g", dbname=seq_len(10)))
}
