% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transposetable.R
\name{transpose_table}
\alias{transpose_table}
\title{Transpose a data table}
\usage{
transpose_table(fnamein, fnameout, wdir = getwd())
}
\arguments{
\item{fnamein}{character vector that specifies the name of
tab-delimited text file with the input data table.}

\item{fnameout}{character vector that specifies the name of output file
where the transposed data table will be saved.}

\item{wdir}{character vector that specifies the name of the working
directory for the input/output files (defaults to the current R directory).}
}
\value{
no return value
}
\description{
Converts table rows to columns and columns to rows.
}
\examples{

# Example with data files included in the package:

# Load example gene expression data table for 2 genes
fdat <- system.file("extdata", "example_genes.txt", package = "kmcut")

transpose_table(fnamein = fdat,
                fnameout = "example_genes_transposed.txt")

# This will create in the current working directory a tab-delimited text
# file with the transposed table: "example_genes_transposed.txt"
}
