% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mismatch.R
\docType{methods}
\name{mismatchKernel}
\alias{getFeatureSpaceDimension,MismatchKernel-method}
\alias{mismatchKernel}
\title{Mismatch Kernel}
\usage{
mismatchKernel(k = 3, m = 1, r = 1, normalized = TRUE, exact = TRUE,
  ignoreLower = TRUE, presence = FALSE)

\S4method{getFeatureSpaceDimension}{MismatchKernel}(kernel, x)
}
\arguments{
\item{k}{length of the substrings also called kmers; this parameter defines
the size of the feature space, i.e. the total number of features considered
in this kernel is |A|^k, with |A| as the size of the alphabet (4 for DNA
and RNA sequences and 21 for amino acid sequences). Default=3}

\item{m}{number of maximal mismatch per kmer. The allowed value range is
between 1 and k-1. The processing effort for this kernel is highly dependent
on the value of m and only small values will allow efficient processing.
Default=1}

\item{r}{exponent which must be > 0 (see details section in
\link{spectrumKernel}). Default=1}

\item{normalized}{a kernel matrix or explicit representation generated with
this kernel will be normalized(details see below). Default=TRUE}

\item{exact}{use exact character set for the evaluation (details see below).
Default=TRUE}

\item{ignoreLower}{ignore lower case characters in the sequence. If the
parameter is not set lower case characters are treated like uppercase.
Default=TRUE}

\item{presence}{if this parameter is set only the presence of a kmers will
be considered, otherwise the number of occurances of the kmer is used.
Default=FALSE}

\item{kernel}{a sequence kernel object}

\item{x}{one or multiple biological sequences in the form of a
\code{\linkS4class{DNAStringSet}}, \code{\linkS4class{RNAStringSet}},
\code{\linkS4class{AAStringSet}} (or as \code{\linkS4class{BioVector}})}
}
\value{
mismatchKernel: upon successful completion, the function returns a kernel
object of class \code{\linkS4class{MismatchKernel}}.

of getDimFeatureSpace:
dimension of the feature space as numeric value
}
\description{
Create a mismatch kernel object and the kernel matrix
}
\details{
Creation of kernel object\cr\cr
The function 'mismatchKernel' creates a kernel object for the mismatch
kernel. This kernel object can then be used with a set of DNA-, RNA- or
AA-sequences to generate a kernel matrix or an explicit representation for
this kernel. For values different from 1 (=default value) parameter
\code{r} leads to a transfomation of similarities by taking each element of
the similarity matrix to the power of r. If \code{normalized=TRUE}, the
feature vectors are scaled to the unit sphere before computing the
similarity value for the kernel matrix. For two samples with the feature
vectors \code{x} and \code{y} the similarity is computed as:
\deqn{s=\frac{\vec{x}^T\vec{y}}{\|\vec{x}\|\|\vec{y}\|}}{s=(x^T y)/(|x| |y|)}
For an explicit representation generated with the feature map of a
normalized kernel the rows are normalized by dividing them through their
Euclidean norm. For parameter \code{exact=TRUE} the sequence characters
are interpreted according to an exact character set. If the flag is not
set ambigous characters from the IUPAC characterset are also evaluated.
The annotation specific variant (for details see \link{positionMetadata})
and the position dependent variant (for details see
\link{annotationMetadata}) are not available for this kernel.\cr\cr
Creation of kernel matrix\cr\cr
The kernel matrix is created with the function \code{\link{getKernelMatrix}}
or via a direct call with the kernel object as shown in the examples below.
}
\examples{
## instead of user provided sequences in XStringSet format
## for this example a set of DNA sequences is created
## RNA- or AA-sequences can be used as well with the mismatch kernel
dnaseqs <- DNAStringSet(c("AGACTTAAGGGACCTGGTCACCACGCTCGGTGAGGGGGACGGGGTGT",
                          "ATAAAGGTTGCAGACATCATGTCCTTTTTGTCCCTAATTATTTCAGC",
                          "CAGGAATCAGCACAGGCAGGGGCACGGCATCCCAAGACATCTGGGCC",
                          "GGACATATACCCACCGTTACGTGTCATACAGGATAGTTCCACTGCCC",
                          "ATAAAGGTTGCAGACATCATGTCCTTTTTGTCCCTAATTATTTCAGC"))
names(dnaseqs) <- paste("S", 1:length(dnaseqs), sep="")

## create the kernel object with one mismatch per kmer
mm <- mismatchKernel(k=2, m=1, normalized=FALSE)
## show details of kernel object
mm

## generate the kernel matrix with the kernel object
km <- mm(dnaseqs)
dim(km)
km[1:5, 1:5]

## alternative way to generate the kernel matrix
km <- getKernelMatrix(mm, dnaseqs)
km[1:5,1:5]

\dontrun{
## plot heatmap of the kernel matrix
heatmap(km, symm=TRUE)
}
}
\author{
Johannes Palme
}
\references{
\url{https://github.com/UBod/kebabs}\cr\cr
C.S. Leslie, E. Eskin, J. Weston, and W.S. Noble.
Mismatch string kernels for discriminative protein classification.
\emph{Bioinformatics}, 1:1-10.
DOI: \doi{10.1093/bioinformatics/btg431}.
\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576.
DOI: \doi{10.1093/bioinformatics/btv176}.
}
\seealso{
\code{\link{kernelParameters}}, \code{\link{getKernelMatrix}},
\code{\link{getExRep}}, \code{\link{spectrumKernel}},
\code{\link{gappyPairKernel}}, \code{\link{motifKernel}},
\code{\linkS4class{MismatchKernel}}
}
\keyword{kernel}
\keyword{methods}
\keyword{mismatch}
\keyword{mismatchKernel}

