% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMainTitleBoundingBox.R
\name{getMainTitleBoundingBox}
\alias{getMainTitleBoundingBox}
\title{getMainTitleBoundingBox}
\usage{
getMainTitleBoundingBox(karyoplot)
}
\arguments{
\item{karyoplot}{a \code{karyoplot} object returned by a call to \code{plotKaryotype}}
}
\value{
Returns a list with four elements (x0, x1, y0 and y1), each of them an 
integer with the coordinates for the main title
}
\description{
Return the regions where the chromosome names should be placed
}
\details{
Given a KaryoPlot object, return the regions where the main plot
should be placed. The position will depend on the plot type used.
}
\note{
In general, this function is automatically called by karyoploteR
and the user never needs to call it.
}
\examples{

kp <- plotKaryotype()
bb <- getMainTitleBoundingBox(kp)
 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpAddMainTitle}}
}
