% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCytobands.R
\name{getCytobands}
\alias{getCytobands}
\title{getCytobands}
\usage{
getCytobands(genome="hg19", use.cache=TRUE)
}
\arguments{
\item{genome}{(character or other) specifies a genome using the UCSC genome name. Defaults to "hg19". If it's not a \code{character}, genome is ignored and and empty \code{GRanges} is returned.}

\item{use.cache}{(boolean) wether to use or not the cytoband information included in the packge. \code{use.cache=FALSE} will force a download from the UCSC.}
}
\value{
It returns a \code{\link{GenomicRanges}} object with the cytobands of the specified genome. If no cytobands are available for any reason, an empty \code{GRanges} is returned.
}
\description{
Get the cytobands of the specified genome.
}
\details{
It returns \code{GRanges} object with the cytobands of the specified genome. 
The cytobands for some organisms and genome versions have been pre-downloaded from UCSC
and included in the \code{karyoploteR} package. For any other genome, \code{getCytobands}
will use \code{rtracklayer} to try to fetch the \code{cytoBandIdeo} table from UCSC. If for
some reason it is not possible to retrieve the cytobands, it will return an empty \code{GRanges}
object. Setting the parameter \code{use.cache} to \code{FALSE}, the data included in the 
package will be ignored and the cytobands will be downloaded from UCSC.

The genomes (and versions) with pre-downloaded cytobands are: hg18, hg19, hg38, mm9, mm10, mm39, 
     rn5, rn6, rn7, susScr11, 
     bosTau9, bosTau8, equCab3, equCab2, panTro6, panTro5, rheMac10,
     danRer10, danRer11, xenTro10, dm3, dm6, 
     ce6, ce10, ce11, sacCer2, sacCer3
}
\note{
This function is memoised (cached) using the \code{\link{memoise}} package. To empty the 
cache, use \code{\link{forget}(getCytobands)}
}
\examples{
 
#get the cytobands for hg19 (using the data included in the package)
cyto <- getCytobands("hg19")


#get the cytobands for Drosophila Melanogaster
cyto <- getCytobands("dm6")

 
}
\seealso{
\code{\link{plotKaryotype}}
}
