% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{IsomirDataSeq-class}
\alias{IsomirDataSeq-class}
\alias{IsomirDataSeq}
\title{Class that contains all isomiRs annotation for all samples}
\description{
The \link{IsomirDataSeq} is a subclass of
\code{SummarizedExperiment}.
used to store the raw data, intermediate calculations and results of an
miRNA/isomiR analysis. This class stores all raw isomiRs
data for each sample, processed information,
summary for each isomiR type,
raw counts, normalized counts, and table with
experimental information for each sample.
}
\details{
\link{IsomirDataSeqFromFiles} creates this object using seqbuster
output files.

Methods for this objects are \code{\link[=counts]{counts()}} to get
count matrix and \code{\link[=isoSelect]{isoSelect()}}
for miRNA/isomiR selection. Functions
available for this object are \code{\link[=isoCounts]{isoCounts()}} for
count matrix creation,
\code{\link[=isoNorm]{isoNorm()}} for normalization,
\code{\link[=isoDE]{isoDE()}} for
differential expression.
\code{\link[=isoPlot]{isoPlot()}} helps with basic expression plot.

\code{metadata} contains one list:
\itemize{
\item \code{rawData} is a \link{data.frame}
with the information of each sequence found in the data
and the counts for each sample.
}

The naming of isomiRs follows these rules:
\itemize{
\item miRNA name
\item type:ref if the sequence is the same as the miRNA reference.
\code{iso} if the sequence has variations.
\item \verb{iso_5p tag}:indicates variations at 5 position.
The naming contains two words: \code{direction - nucleotides},
where direction can be UPPER CASE NT
(changes upstream of the 5 reference position) or
LOWER CASE NT (changes downstream of the 5 reference position).
\code{0} indicates no variation, meaning the 5 position is
the same as the reference. After \code{direction},
it follows the nucleotide/s that are added (for upstream changes)
or deleted (for downstream changes).
\item \verb{iso_3p tag}:indicates variations at 3 position.
The naming contains two words: \code{direction - nucleotides},
where direction can be LOWER CASE NT
(upstream of the 3 reference position) or
UPPER CASE NT (downstream of the 3 reference position).
\code{0} indicates no variation, meaning the 3 position is
the same as the reference. After \code{direction},
it follows the nucleotide/s that are added (for downstream changes)
or deleted (for upstream chanes).
\item \verb{iso_add tag}:indicates nucleotides additions at 3 position.
The naming contains two words: \code{direction - nucleotides},
where direction is UPPER CASE NT
(upstream of the 5 reference position).
\code{0} indicates no variation, meaning the 3 position
has no additions. After \code{direction},
it follows the nucleotide/s that are added.
\item \verb{iso_snv tag}: indicates nucleotides substitutions along
the sequences. The naming contains three words:
\code{position-nucleotide@isomiR-nucleotide@reference}.
\item \verb{iso_snv_seed tag}: same as \code{iso_snv} tag,
but only if the change happens between nucleotide 2 and 8.
}

In general nucleotides in UPPER case mean insertions respect
to the reference sequence, and nucleotides in LOWER case
mean deletions respect to the reference sequence.
}
\examples{
path <- system.file("extra", package="isomiRs")
fn_list <- list.files(path, pattern="mirna", full.names = TRUE)
de <- data.frame(row.names=c("f1" , "f2"),
                 condition = c("newborn", "newborn"))
ids <- IsomirDataSeqFromFiles(fn_list, coldata=de)

head(counts(ids))

}
