% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addImmunogenList.R
\name{addImmunogenList}
\alias{addImmunogenList}
\title{Add multiple immunogens to the Protein DataFrame}
\usage{
addImmunogenList(proteinDF, immunogenDF)
}
\arguments{
\item{proteinDF}{Protein DataFrame created by call to getProteinFeatures()}

\item{immunogenDF}{DataFrame where each row represents an immunogen.
Must contain columns: `start` (integer) and `end` (integer) or `seq` (string), and `name` (string).}
}
\value{
Updated Protein DataFrame with all immunogens added as new columns
}
\description{
Calls `addImmunogen()` for each row in `immunogenDF` to add multiple immunogens
to the given `proteinDF`.
}
\examples{
proteinDF <- getProteinFeatures("P55087")
immunogenDF <- data.frame(
  start = c(10, 40, NA),
  end = c(30, 60, NA),
  seq = c(NA, NA, "RFKEAFSKAAQQTKGSYMEVEDNRSQVETDD"),
  name = c("A12", "B34", "HPA"),
  stringsAsFactors = FALSE
)
proteinDF <- addImmunogenList(proteinDF, immunogenDF)
}
