% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateGeneUsage.R
\name{calculateGeneUsage}
\alias{calculateGeneUsage}
\title{Quantifcation of Gene-Locus Usage}
\usage{
calculateGeneUsage(
  input.data,
  loci,
  levels = NULL,
  summary.fun = c("proportion", "count", "percent")
)
}
\arguments{
\item{input.data}{A data.frame whose rows are sequences / clones and whose
columns named in `loci` contain gene identifiers.}

\item{loci}{Character vector of length 1 or 2 giving the column names.}

\item{levels}{Optional list of length 1 or 2 with the full set of factor
levels to include.  Missing levels are filled with zeros. If `NULL`
(default) only observed levels appear.}

\item{summary.fun}{Character string choosing the summary statistic:
* `"proportion"` (default) – each cell sums to 1 over the table.  
* `"count"`      – raw counts.  
* `"percent"`    – proportion × 100.}
}
\value{
Named numeric **vector** (single locus) or numeric **matrix**
  (paired loci). For `"proportion"` and `"percent"` results sum to 1 or 100.
}
\description{
Computes either the **counts**, **proportions** (default), or **percentages**
of one locus *or* a locus pair that are already present as columns in
`input.data`.  No external dependencies.
}
\examples{
df <- data.frame(V = c("TRBV7-2","TRBV7-2","TRBV5-1"),
                 J = c("TRBJ2-3","TRBJ2-5","TRBJ2-3"))
calculateGeneUsage(df, "V",          summary = "count")
calculateGeneUsage(df, c("V","J"),   summary = "percent")

}
