% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenizeSequences.R
\name{tokenizeSequences}
\alias{tokenizeSequences}
\title{Generate Tokenized Sequences from Amino Acid String}
\usage{
tokenizeSequences(
  input.sequences,
  add.startstop = TRUE,
  start.token = "!",
  stop.token = "^",
  max.length = NULL,
  convert.to.matrix = TRUE,
  padding.symbol = NULL,
  verbose = TRUE
)
}
\arguments{
\item{input.sequences}{The amino acid or nucleotide sequences to use}

\item{add.startstop}{Add start and stop tokens to the sequence}

\item{start.token}{The character to use for the start token}

\item{stop.token}{The character to use for the stop token}

\item{max.length}{Additional length to pad, NULL will pad sequences 
to the max length of input.sequences}

\item{convert.to.matrix}{Return a matrix (TRUE) or a vector (FALSE)}

\item{padding.symbol}{Single character used for right-padding.}

\item{verbose}{Print messages corresponding to the processing step}
}
\value{
Integer matrix (rows = sequences, cols = positions) or list of vectors.
}
\description{
Use this to transform amino acid sequences into tokens in preparing for 
deep learning models.
}
\examples{
new.sequences <- generateSequences(prefix.motif = "CAS",
                                   suffix.motif = "YF",
                                   number.of.sequences = 100,
                                   min.length = 8,
                                   max.length = 16)
                          
sequence.matrix <- tokenizeSequences(new.sequences, 
                                    add.startstop = TRUE,
                                    start.token = "!",
                                    stop.token = "^", 
                                    convert.to.matrix = TRUE)
                        
}
