% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{shannon_entropy}
\alias{shannon_entropy}
\title{Shannon Diversity Index (Entropy)}
\usage{
shannon_entropy(cnt)
}
\arguments{
\item{cnt}{Numeric vector of non-negative counts (one entry per clone/
residue/OTU).  Zero counts are ignored.}
}
\value{
A single numeric value (>= 0).  When `cnt` contains exactly one
  positive entry the function returns `0`.
}
\description{
Calculates Shannon’s information entropy (often denoted *H*) for a set
of clone or sequence counts.
}
\details{
\deqn{H' \;=\; -\sum_{i = 1}^{S} p_i \ln p_i}

where *p*<sub>*i*</sub> = *n*<sub>*i*</sub> / *N* are the relative
frequencies (proportions) of each of the *S* distinct categories.
}
\examples{
counts <- c(A = 12, B = 4, C = 4)
shannon_entropy(counts)
}
\seealso{
[norm_entropy()], [inv_simpson()]
}
