% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutateSequences.R
\name{mutateSequences}
\alias{mutateSequences}
\title{Randomly Mutate Sequences of Amino Acids}
\usage{
mutateSequences(
  input.sequences,
  number.of.sequences = 1,
  mutation.rate = 0.01,
  position.start = NULL,
  position.end = NULL,
  sequence.dictionary = amino.acids
)
}
\arguments{
\item{input.sequences}{The amino acid or nucleotide sequences to use}

\item{number.of.sequences}{The number of mutated sequences to return}

\item{mutation.rate}{The rate of mutations to introduce into sequences}

\item{position.start}{The starting position to mutate along the sequence
\strong{Default} = NULL will start the random mutations at position 1}

\item{position.end}{The ending position to mutate along the sequence
\strong{Default} = NULL will end the random mutations at the last position}

\item{sequence.dictionary}{The letters to use in sequence mutation
(default are all amino acids)}
}
\value{
A vector of mutated sequences
}
\description{
Use this to mutate or mask sequences for purposes of testing code, 
training models, or noise.
}
\examples{
sequences <- generateSequences(prefix.motif = "CAS",
                               suffix.motif = "YF",
                               number.of.sequences = 100,
                               min.length = 8,
                               max.length = 16)
                                
mutated_sequences <- mutateSequences(sequences, 
                                     number.of.sequences = 1,
                                     position.start = 3,
                                     position.end = 8)

}
