% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{gini_simpson}
\alias{gini_simpson}
\title{Gini–Simpson Diversity}
\usage{
gini_simpson(cnt)
}
\arguments{
\item{cnt}{Numeric vector of non-negative counts (one entry per clone/
residue/OTU).  Zero counts are ignored.}
}
\value{
Value in the interval [0, 1].  Higher numbers indicate greater
  heterogeneity.
}
\description{
Computes the complement of Simpson’s index (also called the
Gini–Simpson index or probability of interspecific encounter):
}
\details{
\deqn{1 - \lambda = 1 - \sum_{i} p_i^{\,2}}
}
\examples{
gini_simpson(c(10, 5, 5))
}
