% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{loadCramTrackFromURL}
\alias{loadCramTrackFromURL}
\title{load a cram track which, with index, is served up by http}
\usage{
loadCramTrackFromURL(
  session,
  id,
  trackName,
  cramURL,
  indexURL,
  deleteTracksOfSameName = TRUE
)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{trackName}{character string}

\item{cramURL}{character string http url for the bam file, 
typically very large}

\item{indexURL}{character string http url for the bam file index, 
typically small}

\item{deleteTracksOfSameName}{logical, default TRUE}
}
\value{
nothing
}
\description{
load a remote cram track
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{track_loaders}
