% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaledHydropathy.R
\name{scaledHydropathyLocal}
\alias{scaledHydropathyLocal}
\title{Calculate the Average Scaled Hydropathy of an Amino Acid Sequence}
\usage{
scaledHydropathyLocal(
  sequence,
  window = 9,
  plotResults = TRUE,
  proteinName = NA,
  ...
)
}
\arguments{
\item{sequence}{amino acid sequence as a single character string,
a vector of single characters, or an AAString object.
It also supports a single character string that specifies
the path to a .fasta or .fa file.}

\item{window}{a positive, odd integer. 9 by default.
Sets the size of sliding window, must be an odd number.
The window determines the number of residues to be analyzed and averaged
for each position along the sequence.}

\item{plotResults}{logical value, TRUE by default.
If \code{plotResults = TRUE} a plot will be the output.
If \code{plotResults = FALSE} the output is a data frame with scores for
each window analyzed.}

\item{proteinName}{character string with length = 1.
optional setting to replace the name of the plot if hydropathy = TRUE.}

\item{...}{any additional parameters, especially those for plotting.}
}
\value{
see plotResults argument
}
\description{
This is used to calculate the scaled hydropathy of an amino acid
  sequence using a sliding window. The output is either a data frame or graph
  showing the calculated scores for each window along the sequence.
}
\section{Plot Colors}{

  For users who wish to keep a common aesthetic, the following colors are
  used when plotResults = TRUE. \cr
  \itemize{
  \item Dynamic line colors: \itemize{
  \item Close to 0 = "skyblue3" or "#6CA6CD"
  \item Close to 1 = "chocolate1" or "#FF7F24"
  \item Close to midpoint = "grey65" or "#A6A6A6"}}
}

\examples{
#Amino acid sequences can be character strings
aaString <- "ACDEFGHIKLMNPQRSTVWY"
#Amino acid sequences can also be character vectors
aaVector <- c("A", "C", "D", "E", "F",
              "G", "H", "I", "K", "L",
              "M", "N", "P", "Q", "R",
              "S", "T", "V", "W", "Y")
#Alternatively, .fasta files can also be used by providing
  ##The path to the file as a character string.

exampleDF <- scaledHydropathyLocal(aaString,
                                   plotResults = FALSE)
head(exampleDF)

exampleDF <- scaledHydropathyLocal(aaVector,
                                   plotResults = FALSE)
head(exampleDF)

#Changing window will alter the number of residues analyzed
exampleDF_window3 <- scaledHydropathyLocal(aaString,
                                           window = 3,
                                           plotResults = FALSE)
head(exampleDF_window3)
exampleDF_window15 <- scaledHydropathyLocal(aaString,
                                            window = 15,
                                            plotResults = FALSE)
head(exampleDF_window15)

#plotResults = TRUE will output a ggplot
  scaledHydropathyLocal(aaString,
                        plot = TRUE)

#since it is a ggplot, you can change or annotate the plot
 gg <- scaledHydropathyLocal(aaVector,
                             window = 3,
                             plot = TRUE)
 gg <- gg + ggplot2::ylab("Local Hydropathy")
  gg <- gg + ggplot2::geom_text(data = exampleDF_window3,
                               ggplot2::aes(label = CenterResidue,
                                            y = WindowHydropathy + 0.1))
 plot(gg)
}
\references{
Kyte, J., & Doolittle, R. F. (1982). A simple method for
  displaying the hydropathic character of a protein.
  Journal of molecular biology, 157(1), 105-132.
}
\seealso{
\code{\link{KDNorm}} for residue values.

Other scaled hydropathy functions: 
\code{\link{KDNorm}},
\code{\link{foldIndexR}()},
\code{\link{meanScaledHydropathy}()},
\code{\link{scaledHydropathyGlobal}()}
}
\concept{scaled hydropathy functions}
