% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chargeHydropathyPlot.R
\name{chargeHydropathyPlot}
\alias{chargeHydropathyPlot}
\title{Charge-Hydropathy Plot}
\usage{
chargeHydropathyPlot(
  sequence,
  displayInsolubility = TRUE,
  insolubleValue = 0.7,
  proteinName = NA,
  customPlotTitle = NA,
  pH = 7,
  pKaSet = "IPC_protein",
  plotResults = TRUE,
  ...
)
}
\arguments{
\item{sequence}{amino acid sequence (or pathway to a fasta file)
as a character string. Supports multiple sequences / files, as a
character vector of strings. Additionally, this supports a single protein
as character vectors. Multiple proteins are not supported as a character
vector of single characters.}

\item{displayInsolubility}{logical value, TRUE by default.
This adds (or removes when FALSE) the vertical line
separating collapsed proteins and insoluble proteins}

\item{insolubleValue}{numerical value. 0.7 by default.
Ignored when \code{displayInsolubility = FALSE}. Plots the vertical line
\eqn{<H> = displayInsolubility}.}

\item{proteinName, customPlotTitle}{optional character string. NA by default.
Used to either add the name of the protein to the plot title when there
is only one protein, or to create a custom plot title for the output.}

\item{pH}{numeric value, 7.0 by default.
The environmental pH is used to calculate residue charge.}

\item{pKaSet}{pKa set used for charge calculations. See
\code{\link{netCharge}} for additional details}

\item{plotResults}{logical value, TRUE by default.
This determines what is returned. If \code{plotResults = FALSE}, a
data frame is returned with the Sequence(s), Average Scaled Hydropathy,
and Average Net Charge.
If  \code{plotResults = TRUE}, a graphical output is returned (ggplot)
showing the Charge Hydropathy Plot (recommended).}

\item{...}{additional arguments to be passed to
\link[idpr:netCharge]{idpr::netCharge()},
\link[idpr:meanScaledHydropathy]{idpr::meanScaledHydropathy()} or
\code{\link[ggplot2]{ggplot}}}
}
\value{
Graphical values of Charge-Hydropathy Plot
}
\description{
This function calculates the average net charge <R> and the average
  scaled hydropathy <H> and visualizes the data. There are known boundaries
  on the C-H plot that separate extended and collapsed proteins. \cr
  This was originally described in Uversky et al. (2000)\cr
  \url{https://doi.org/10.1002/1097-0134(20001115)41:3<415::AID-PROT130>3.0.CO;2-7}
  . \cr
  The plot returned is based on the charge-hydropathy plot from
  Uversky (2016) \url{https://doi.org/10.1080/21690707.2015.1135015}. \cr
  See Uversky (2019) \url{https://doi.org/10.3389/fphy.2019.00010} for
  additional information and a recent review on the topic.
  This plot has also been referred to as a "Uversky Plot".
}
\section{Plot Colors}{

  For users who wish to keep a common aesthetic, the following colors are
  used when plotResults = TRUE. \cr
  \itemize{
  \item Point(s) = "chocolate1" or "#ff7f24"
  \item Lines = "black"}
}

\examples{
#Amino acid sequences can be character strings
aaString <- "ACDEFGHIKLMNPQRSTVWY"
#Amino acid sequences can also be character vectors
aaVector <- c("A", "C", "D", "E", "F",
              "G", "H", "I", "K", "L",
              "M", "N", "P", "Q", "R",
              "S", "T", "V", "W", "Y")
#Alternatively, .fasta files can also be used by providing
##The path to the file as a character string
chargeHydropathyPlot(sequence = aaString)
chargeHydropathyPlot( sequence = aaVector)

#This function also supports multiple sequences
#only as character strings or .fasta files
multipleSeq <- c("ACDEFGHIKLMNPQRSTVWY",
               "ACDEFGHIK",
               "LMNPQRSTVW")
chargeHydropathyPlot(sequence = multipleSeq)

#since it is a ggplot, we can add additional annotations or themes
chargeHydropathyPlot(
 sequence = multipleSeq)  +
  ggplot2::theme_void()

chargeHydropathyPlot(
  sequence = multipleSeq)  +
  ggplot2::geom_hline(yintercept = 0,
                     color = "red")

#choosing the pKa set used for calculations
chargeHydropathyPlot(
  sequence = multipleSeq,
  pKaSet = "EMBOSS")

}
\references{
Kozlowski, L. P. (2016). IPC – Isoelectric Point Calculator. Biology
  Direct, 11(1), 55. \url{https://doi.org/10.1186/s13062-016-0159-9} \cr
  Kyte, J., & Doolittle, R. F. (1982). A simple method for
  displaying the hydropathic character of a protein.
  Journal of molecular biology, 157(1), 105-132. \cr
  Uversky, V. N. (2019). Intrinsically Disordered Proteins and Their
  “Mysterious” (Meta)Physics. Frontiers in Physics, 7(10).
  \url{https://doi.org/10.3389/fphy.2019.00010} \cr
  Uversky, V. N. (2016). Paradoxes and wonders of intrinsic disorder:
  Complexity of simplicity. Intrinsically Disordered Proteins, 4(1),
  e1135015. \url{https://doi.org/10.1080/21690707.2015.1135015} \cr
  Uversky, V. N., Gillespie, J. R., & Fink, A. L. (2000).
  Why are “natively unfolded” proteins unstructured under physiologic
  conditions?. Proteins: structure, function, and bioinformatics, 41(3),
  415-427.
  \url{https://doi.org/10.1002/1097-0134(20001115)41:3<415::AID-PROT130>3.0.CO;2-7}
}
\seealso{
\code{\link{netCharge}} and
  \code{\link{meanScaledHydropathy}}
  for functions used to calculate values.
}
