% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_volcano.R
\name{plot_volcano}
\alias{plot_volcano}
\title{Volcano plot for log fold changes and log p-values}
\usage{
plot_volcano(
  res_obj,
  FDR = 0.05,
  ylim_up = NULL,
  vlines = NULL,
  title = NULL,
  intgenes = NULL,
  intgenes_color = "steelblue",
  labels_intgenes = TRUE,
  labels_repel = TRUE
)
}
\arguments{
\item{res_obj}{A \code{\link[DESeq2:DESeqResults]{DESeq2::DESeqResults()}} object}

\item{FDR}{Numeric value, the significance level for thresholding adjusted p-values}

\item{ylim_up}{Numeric value, Y axis upper limits to restrict the view}

\item{vlines}{The x coordinate (in absolute value) where to draw vertical lines,
optional}

\item{title}{A title for the plot, optional}

\item{intgenes}{Vector of genes of interest. Gene symbols if a \code{symbol}
column is provided in \code{res_obj}, or else the identifiers specified in the
row names}

\item{intgenes_color}{The color to use to mark the genes on the main plot.}

\item{labels_intgenes}{Logical, whether to add the gene identifiers/names close
to the marked plots}

\item{labels_repel}{Logical, whether to use \code{geom_text_repel} for placing the
labels on the features to mark}
}
\value{
An object created by \code{ggplot}
}
\description{
Volcano plot for log fold changes and log p-values in the ggplot2 framework, with
additional support to annotate genes if provided.
}
\details{
The genes of interest are to be provided as gene symbols if a \code{symbol}
column is provided in \code{res_obj}, or else b< using  the identifiers specified
in the row names
}
\examples{
library("airway")
data("airway", package = "airway")
airway
dds_airway <- DESeq2::DESeqDataSetFromMatrix(assay(airway),
  colData = colData(airway),
  design = ~ cell + dex
)

# subsetting for quicker run, ignore the next two commands if regularly using the function
gene_subset <- c(
  "ENSG00000103196", # CRISPLD2
  "ENSG00000120129", # DUSP1
  "ENSG00000163884", # KLF15
  "ENSG00000179094", # PER1
  rownames(dds_airway)[rep(c(rep(FALSE, 99), TRUE), length.out = nrow(dds_airway))]
) # 1\% of ids
dds_airway <- dds_airway[gene_subset, ]

dds_airway <- DESeq2::DESeq(dds_airway)
res_airway <- DESeq2::results(dds_airway)

plot_volcano(res_airway)
}
