% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registerFeatureSetCollections.R
\name{registerFeatureSetCollections}
\alias{registerFeatureSetCollections}
\alias{registerFeatureSetCommands}
\alias{getFeatureSetCollections}
\alias{getFeatureSetCommands}
\title{Register feature set collections}
\usage{
registerFeatureSetCollections(se, collections)

registerFeatureSetCommands(se, commands)

getFeatureSetCollections(se)

getFeatureSetCommands(se)
}
\arguments{
\item{se}{The \linkS4class{SummarizedExperiment} object to be used in \code{\link{iSEE}}.}

\item{collections}{A named list containing one or more \linkS4class{CharacterList} objects.
Each entry represents a collection of feature sets (see Details) and should be named.}

\item{commands}{A named list containing two character vectors of commands to use to generate collections and sets.}
}
\value{
For \code{registerFeatureSetCollections} and \code{registerFeatureSetCommands},
a modified \code{se} is returned that contains the feature set collections or commands, respectively.
This can be used with \linkS4class{FeatureSetTable}s in \code{\link{iSEE}} calls.

For \code{getFeatureSetCollections}, the list of CharacterLists is returned.
Alternatively \code{NULL}, if no such list was stored by \code{registerFeatureSetCollections}.

For \code{getFeatureSetCommands}, the list of of commands is returned containing \code{collections} and \code{sets}.
Alternatively \code{NULL}, if no such list was stored by \code{registerFeatureSetCommands}.
}
\description{
Register feature set collations and their annotations for display in \linkS4class{FeatureSetTable}s.
}
\details{
Arbitrary feature sets are challenging as there is no obvious place to store them.
\code{registerFeatureSetCollections} and friends will insert these sets into the \code{\link{metadata}} of the SummarizedExperiment object,
allowing the corresponding getter functions to quickly extract them later within the \code{iSEE} app.

\code{collections} should be a named list containing \linkS4class{CharacterList} objects.
Each \linkS4class{CharacterList} represents a collection where each entry is a feature set, i.e., a character vector corresponding to some of the row names of \code{se}.
The \code{\link{mcols}} can contain additional per-set fields (e.g., descriptions, enrichment statistics) that will be shown in the \linkS4class{FeatureSetTable}.

\code{commands} should be a list containing:
\itemize{
\item \code{collections}, a named character vector where each entry is named after a feature set collection.
Each entry should be a string containing R commands to define a data.frame named \code{tab}, where each row is a feature set and the row names are the names of those sets.
\item \code{sets}, a character vector where each entry is named after a feature set collection in the same order as \code{commands$collections}.
Each entry should be a string containing R commands to define a character vector named \code{selected} containing the identity of all rows of the SummarizedExperiment in the set of interest.
(These commands can assume that a \code{.set_id} variable is present containing the name of the chosen feature set,
as well as the \code{se} variable containing the input SummarizedExperiment object.)
}

If neither \code{collections} nor \code{commands} are provided, any previously registered content in \code{se} is removed.
}
\examples{
library(scRNAseq)
sce <- LunSpikeInData(location=FALSE)

# Make up some random collections.
random <- CharacterList(
   Aaron = sample(rownames(sce), 10),
   Kevin = sample(rownames(sce), 20),
   Charlotte = sample(rownames(sce), 30),
   Fed = sample(rownames(sce), 40)
)
mcols(random)$p.value <- runif(4)

# Storing the collections inside our SummarizedExperiment.
sce <- registerFeatureSetCollections(sce, list(random=random))
getFeatureSetCollections(sce)

if (interactive()) {
    iSEE(sce, initial=list(FeatureSetTable()))
}

}
\author{
Aaron Lun
}
