% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEEindexResource-class.R
\name{iSEEindexS3Resource-class}
\alias{iSEEindexS3Resource-class}
\alias{iSEEindexS3Resource}
\alias{precache,iSEEindexS3Resource-method}
\title{The iSEEindexS3Resource class}
\usage{
iSEEindexS3Resource(x)
}
\arguments{
\item{x}{List of metadata. See Details.}
}
\value{
The constructor function \code{iSEEindexS3Resource()} returns an object of
object of class \code{iSEEindexS3Resource}.
}
\description{
The iSEEindexS3Resource class represents a cloud storage resource accessible
via the
\href{https://cran.r-project.org/package=paws.storage}{paws.storage}
R package.
A URI for this type of resource uses the prefix \dQuote{s3://}.
}
\details{
Required metadata:

\describe{
\item{uri}{Character scalar. URI of the resource.}
}
}
\section{Slot overview}{

This class inherits all slots from its parent class
\linkS4class{iSEEindexResource}.

Furthermore, this class defines the additional slot(s) below:
\describe{
\item{region}{AWS region.}
}
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a
\linkS4class{iSEEindexS3Resource} class.
Refer to the documentation for each method for more details on the remaining
arguments.

\itemize{
\item \code{\link{precache}(x, ..., temp_dir = tempdir())} trims the \verb{s3://}
prefix, parses information encoded in the remainder of the URI,
downloads the resource from AWS S3 using that information,
and caches a copy of the resource located at the resulting file path using
\pkg{BiocFileCache}, before returning the file path to the cached file.
}
}

\section{URI format}{

The URI must correspond to an existing file in an AWS S3 compatible cloud
storage system.

For instance:

\if{html}{\out{<div class="sourceCode">}}\preformatted{s3://bucket/prefix/index.rds
}\if{html}{\out{</div>}}

For details about authentication, see section \dQuote{AWS Credentials} below.
}

\section{Pre-caching}{

Additional arguments to the \code{\link{precache}(x, ..., temp_dir = tempdir())}:

\describe{
\item{\code{temp_dir}}{Scalar character, the directory to store the downloaded file
in before it is handed over to \pkg{BiocFileCache}. This directory will be created
recursively if it doesn't already exist.}
}
}

\section{AWS Credentials and region settings}{

For detailed information, please consult the
\href{https://github.com/paws-r/paws/blob/main/docs/credentials.md}{paws R package documentation}.

Currently, you must have the \href{https://aws.amazon.com/cli/}{AWS Command Line Interface}
installed to use AWS SSO with \pkg{paws.storage}.

A default AWS region can be set in the file \verb{~/.aws/config}.
For instance:

\if{html}{\out{<div class="sourceCode">}}\preformatted{[default]
region=eu-west-2
}\if{html}{\out{</div>}}

Optionally, a field named \code{region} can be added in the list of resource
metadata to set the AWS S3 region for each individual resource, e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{- id: ID1
  title: ReprocessedAllenData
  uri: s3://example/ReprocessedAllenData.rds
  description: |
    Reprocessed Allen Data.
  region: eu-west-2
}\if{html}{\out{</div>}}

Regions set in individual resource metadata override the default AWS region
set in \verb{~/.aws/config} (if any).
The region metadata does not need to be set for resources that should use the
default region, and resource classes that do not require region information.

If a default region is NOT set in \verb{~/.aws/config}, then the region MUST be
set in the metadata.

Credentials for all services can be set in the AWS shared credentials file
\verb{~/.aws/credentials}.
For instance:

\if{html}{\out{<div class="sourceCode">}}\preformatted{[default]
aws_access_key_id=your AWS access key
aws_secret_access_key=your AWS secret key
}\if{html}{\out{</div>}}
}

\examples{
# Without region metadata
metadata <- list(uri = "s3://example/path/to/bucket")
x <- iSEEindexS3Resource(metadata)
str(x)

# With region metadata
# NOTE: The @region slot is set to NA pending bugfix (see above).
metadata <- list(uri = "s3://example/path/to/bucket", region = "eu-west-2")
x <- iSEEindexS3Resource(metadata)
str(x)
}
\author{
Thomas Sandmann, Kevin Rue-Albrecht
}
