% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctPerformClassification.R
\name{fctPerformClassification}
\alias{fctPerformClassification}
\title{fctPerformClassification}
\usage{
fctPerformClassification(
  eigengeneData,
  metadata,
  phenotypeVariable,
  significanceThreshold = 0.05
)
}
\arguments{
\item{eigengeneData}{A data frame of eigengenes organized with patient IDs in rows and variables in columns.}

\item{metadata}{A data frame containing metadata, with a column call "Sample" that matches patient IDs in eigengeneData.}

\item{phenotypeVariable}{The variable selected by the user in the Shiny app (response variable).}

\item{significanceThreshold}{A numeric value to filter p-value. Default is 00.5.}
}
\value{
A data frame with metrics such as AUC, Accuracy, and Error Rate for each binary classification.
}
\description{
Performs classification using different methods such as Welch’s T-test, Random Forest, and K-Nearest Neighbors.
}
\examples{
# Simulate eigengene data
set.seed(123)
eigengeneData <- as.data.frame(matrix(rnorm(100), nrow = 10, ncol = 10))
colnames(eigengeneData) <- paste0("ME", 1:10)
rownames(eigengeneData) <- paste0("Sample", 1:10)
# Simulate metadata with a binary phenotype
metadata <- data.frame(
  Sample = paste0("Sample", 1:10),
  Phenotype = rep(c("A", "B"), each = 5),
  stringsAsFactors = FALSE
)
# Run classification
result <- fctPerformClassification(
  eigengeneData = eigengeneData,
  metadata = metadata,
  phenotypeVariable = "Phenotype",
  significanceThreshold = 0.05
)

# View results
head(result$result)

}
