% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctFeaturesAnnotCorrelation.R
\name{fctFeaturesAnnotCorrelation}
\alias{fctFeaturesAnnotCorrelation}
\title{fctFeaturesAnnotCorrelation}
\usage{
fctFeaturesAnnotCorrelation(
  corDataiDataj,
  clusterAssignmentsD1,
  clusterAssignmentsD2,
  loadData1 = loadData1,
  loadData2 = loadData2,
  topn = 5
)
}
\arguments{
\item{corDataiDataj}{A data frame with the first principal component of each protein cluster and their correlations.}

\item{clusterAssignmentsD1}{A data frame containing cluster assignments for metabolites.}

\item{clusterAssignmentsD2}{A data frame containing cluster assignments and Enrichr terms for proteins.}

\item{loadData1}{A prepossessed data matrix resulting from "load data" function from Data1.}

\item{loadData2}{A prepossessed data matrix resulting from "load data" function from Data2.}

\item{topn}{The number of top correlations to select.}
}
\value{
A list containing important features and correlation matrices.
}
\description{
Calculate correlation between the features of top correlated modules.
}
\examples{
# Simulated correlation data
corDataiDataj <- data.frame(
  from = c("blue", "green"),
  to = c("red", "yellow"),
  value = c(0.9, 0.85),
  stringsAsFactors = FALSE
)

# Simulated cluster assignments
clusterAssignmentsD1 <- data.frame(
  feature = c("M1", "M2"),
  col = c("blue", "green"),
  stringsAsFactors = FALSE
)
clusterAssignmentsD2 <- data.frame(
  feature = c("P1", "P2"),
  col = c("red", "yellow"),
  stringsAsFactors = FALSE
)

# Simulated expression matrices
loadData1 <- matrix(rnorm(20), nrow = 5, ncol = 4)
colnames(loadData1) <- c("M1", "M2", "X1", "X2")
rownames(loadData1) <- paste0("Sample", 1:5)

loadData2 <- matrix(rnorm(20), nrow = 5, ncol = 4)
colnames(loadData2) <- c("P1", "P2", "Y1", "Y2")
rownames(loadData2) <- paste0("Sample", 1:5)

# Run the function
result <- fctFeaturesAnnotCorrelation(
  corDataiDataj = corDataiDataj,
  clusterAssignmentsD1 = clusterAssignmentsD1,
  clusterAssignmentsD2 = clusterAssignmentsD2,
  loadData1 = loadData1,
  loadData2 = loadData2,
  topn = 2
)

# View top correlations
result$Top_correlations

}
