% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_array_input.R
\name{get_array_input}
\alias{get_array_input}
\title{Get array information from given format}
\usage{
get_array_input(dir = character(), pattern = character(), chr = NULL,
  projname = "")
}
\arguments{
\item{dir}{A string. The directory path to the folder where store signal intensity file according to chr. Type character}

\item{pattern}{A string. The pattern of all the intensity file. Type character}

\item{chr}{Specify the chromosome you want to generate. Must be of int from 1-22. If not specify, this function will generate files for all chromosomes. Default NULL}

\item{projname}{Name of the project. Type character}
}
\value{
void
}
\description{
If your array input file follow the format in the example, you could use this
 function to extract array LRR and baf. Remember to load library before hands.
Save 4*[# of chr] lists, each list has N entry. N = # of individuals
snp_lrr: SNP LRR intensity; snp_lrr.pos: the position of the SNPs
snp_baf: the BAF of the SNPs; snp_baf.pos: the position of the SNPs
}
\examples{
dir <- system.file("extdata", package="iCNV")
pattern <- paste0('*.csv.arrayicnv$')
get_array_input(dir,pattern,chr=22,projname='icnv.demo.')
}
