% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hype.R
\name{hypeR}
\alias{hypeR}
\title{Calculate enrichment of one or more signatures}
\usage{
hypeR(
  signature,
  genesets,
  test = c("hypergeometric", "kstest"),
  background = 23467,
  power = 1,
  absolute = FALSE,
  pval = 1,
  fdr = 1,
  plotting = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{signature}{A vector of symbols}

\item{genesets}{A gsets/rgsets object or a named list of genesets}

\item{test}{Choose an enrichment type e.g. c("hypergeometric", "kstest")}

\item{background}{Size or character vector of background population genes}

\item{power}{Exponent for weights (kstest only)}

\item{absolute}{Takes max-min score rather than the max deviation from null (kstest only)}

\item{pval}{Filter results to be less than pval cutoff}

\item{fdr}{Filter results to be less than fdr cutoff}

\item{plotting}{Use true to generate plots for each geneset test (may slow performance)}

\item{quiet}{Use true to suppress logs and warnings}
}
\value{
A hyp object
}
\description{
Calculate enrichment of one or more signatures
}
\examples{
genesets <- msigdb_gsets("Homo sapiens", "C2", "CP:KEGG_LEGACY")

signature <- c("IDH3B","DLST","PCK2","CS","PDHB","PCK1","PDHA1","LOC642502",
               "PDHA2","LOC283398","FH","SDHD","OGDH","SDHB","IDH3A","SDHC",
               "IDH2","IDH1","OGDHL","PC","SDHA","SUCLG1","SUCLA2","SUCLG2")

hyp_obj <- hypeR(signature, genesets, background=2522)

}
