% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyp_show.R
\name{hyp_show}
\alias{hyp_show}
\title{Convert a hyp object to a reactable table}
\usage{
hyp_show(hyp_obj, simple = FALSE)
}
\arguments{
\item{hyp_obj}{A hyp object}

\item{simple}{Use true to only include essential columns}
}
\value{
A reactable table
}
\description{
Convert a hyp object to a reactable table
}
\examples{
genesets <- msigdb_gsets("Homo sapiens", "C2", "CP:KEGG_LEGACY")

signature <- c("IDH3B","DLST","PCK2","CS","PDHB","PCK1","PDHA1","LOC642502",
               "PDHA2","LOC283398","FH","SDHD","OGDH","SDHB","IDH3A","SDHC",
               "IDH2","IDH1","OGDHL","PC","SDHA","SUCLG1","SUCLA2","SUCLG2")

hyp_obj <- hypeR(signature, genesets, background=2522)

hyp_show(hyp_obj)

}
