% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gleamTest.R
\name{gleamTest}
\alias{gleamTest}
\title{Perform GLEAM test}
\usage{
gleamTest(query, subject, background, method = c("binom", "hyper"), ...)
}
\arguments{
\item{query, subject}{A vector of bedpe files or a list of genomic
interaction data (\link[S4Vectors:Pairs-class]{Pairs} or
\link[InteractionSet:GInteractions-class]{GInteractions}) or a list of
GRanges object. 'subject' is optional if length of query > 1.}

\item{background}{The test will restricted within the
region. The background is the background of subject if subject is available.
Otherwise, the background is the the background of second element of
comparison group.}

\item{method}{Distribution type for p-value.}

\item{\dots}{parameters used by
\link[InteractionSet:findOverlaps]{findOverlaps}.}
}
\value{
A data.frame of test results.
}
\description{
Run Genomic Loops Enrichment Analysis Method (GLEAM) test. GLEAM identifies
the query is significantly over-represented within the subject
by given background if subject is available. Otherwise, the GLEAM will be
tested among the queries.
}
\examples{
# example code
pd <- system.file("extdata", package = "hicVennDiagram", mustWork = TRUE)
fs <- dir(pd, pattern = ".bedpe", full.names = TRUE)
library(TxDb.Hsapiens.UCSC.hg38.knownGene)
## set.seed(123)
## background <- createGIbackground(fs)
## gleamTest(fs, background = background)
## gleamTest(fs, background = background, method = 'hyper')
grl <- GRangesList(exons=reduce(exons(TxDb.Hsapiens.UCSC.hg38.knownGene)),
 genes=reduce(genes(TxDb.Hsapiens.UCSC.hg38.knownGene)))
gleamTest(fs[seq_along(grl)], grl, background = grl[['exons']])
gleamTest(grl[c(2, 1)], grl, background = grl[['exons']])
gleamTest(grl, background = grl[['genes']])
}
