% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermesData-methods.R
\name{subset}
\alias{subset}
\title{Subsetting \code{AnyHermesData} Objects}
\arguments{
\item{x}{(\code{AnyHermesData})\cr object to subset from.}

\item{subset}{(\code{expression})\cr logical expression based on the \code{rowData} columns to
select genes.}

\item{select}{(\code{expression})\cr logical expression based on the \code{colData} columns to
select samples.}
}
\value{
The subsetted \code{\link{AnyHermesData}} object.
}
\description{
This method subsets \code{\link{AnyHermesData}} objects, based on expressions involving the
\code{rowData} columns and the \code{colData} columns.
}
\note{
Note that this just inherits
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::subset,SummarizedExperiment-method()}}.
}
\examples{
a <- hermes_data
a

# Subset both genes and samples.
subset(a, subset = low_expression_flag, select = DISCSTUD == "N")

# Subset only genes.
subset(a, subset = chromosome == "2")

# Subset only samples.
subset(a, select = AGE > 18)
}
