% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{df_cols_to_factor}
\alias{df_cols_to_factor}
\title{Conversion of Eligible Columns to Factor Variables in a \code{DataFrame}}
\usage{
df_cols_to_factor(data, omit_columns = NULL, na_level = "<Missing>")
}
\arguments{
\item{data}{(\code{DataFrame})\cr input \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame}}.}

\item{omit_columns}{(\code{character} or \code{NULL})\cr which columns should be omitted from
the possible conversion to factor and explicit missing level application.}

\item{na_level}{(\code{string})\cr explicit missing level to be used for factor variables.}
}
\value{
The modified data.
}
\description{
This utility function converts all eligible character and logical variables in a
\code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame}} to factor variables. All factor variables get amended
with an explicit missing level. This includes both \code{NA} and empty strings.
}
\note{
All required \code{rowData} and \code{colData} variables cannot be converted
to ensure proper downstream behavior. These are automatically omitted if found in \code{data}
and therefore do not need to be specified in \code{omit_columns}.
}
\examples{
dat <- colData(summarized_experiment)
any(vapply(dat, is.character, logical(1)))
any(vapply(dat, is.logical, logical(1)))
dat_converted <- df_cols_to_factor(dat)
any(vapply(dat_converted, function(x) is.character(x) || is.logical(x), logical(1)))
}
