% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcTable.R
\name{qualityControl}
\alias{qualityControl}
\title{Quality Control table function. Generate a table that collates quality
control metrics}
\usage{
qualityControl(
  object,
  massError = NULL,
  intensityOutlier = NULL,
  retentionOutlier = NULL,
  monotonicityStat = NULL,
  mobilityOutlier = NULL,
  chargeCorrelation = NULL,
  replicateCorrelation = NULL,
  replicateOutlier = NULL,
  sequenceCheck = NULL,
  spectraCheck = NULL,
  experiment = NULL,
  timepoints = NULL,
  undeuterated = FALSE
)
}
\arguments{
\item{object}{An object of class Qfeatures, with the data used for the analysis}

\item{massError}{The output of the \code{computeMassError} function}

\item{intensityOutlier}{The output of the \code{intensityOutliers} function}

\item{retentionOutlier}{The output of the \code{rTimeOutliers} function}

\item{monotonicityStat}{The output of the \code{computeMonotoneStats} function}

\item{mobilityOutlier}{The output of the \code{imTimeOutliers} function}

\item{chargeCorrelation}{The output of the \code{chargeCorrelationsHdx} function}

\item{replicateCorrelation}{The output of the \code{replicateCorrelation} function}

\item{replicateOutlier}{The output of the \code{replicateOutlier} function}

\item{sequenceCheck}{The output of the \code{compatibleUptake} function}

\item{spectraCheck}{The output of the \code{spectraSimiarity} function}

\item{experiment}{The experimental conditions.}

\item{timepoints}{The timepoints used in the analysis, must include repeat
for replicates}

\item{undeuterated}{A logical indicating whether only the undeuterated data
should be exported}
}
\value{
An object of class \code{DataFrame} containing a summary of the quality
control results.
}
\description{
Quality Control table function. Generate a table that collates quality
control metrics
}
\author{
Oliver Crook
}
