% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdxmsqc-utils.R
\name{plotrTimeOutliers}
\alias{plotrTimeOutliers}
\title{Retention time based analysis}
\usage{
plotrTimeOutliers(
  object,
  leftRT = "leftRT",
  rightRT = "rightRT",
  searchRT = "Search.RT"
)
}
\arguments{
\item{object}{An object of class \code{QFeatures}}

\item{leftRT}{A character indicated pattern associated with left boundary
of retention time search. Default is "leftRT".}

\item{rightRT}{A character indicated pattern associated with right boundary
of retneton time search. Default is "rightRT".}

\item{searchRT}{The actual search retention time pattern.
Default is "Search.RT"}
}
\value{
a ggplot2 object showing distribution of retention time windows.
}
\description{
Retention time based analysis
}
\examples{
data("BRD4df_full")
library(RColorBrewer)

plotrTimeOutliers(BRD4df_full)
}
\author{
Oliver Crook
}
