% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileEquiv_topDown2.R
\name{iterEquivClust}
\alias{iterEquivClust}
\title{For each combination of the specified levels in the choosen GO ontologies, 
compute the equivalence threshold distance matrix and generate a dendrogram from it.}
\usage{
iterEquivClust(geneLists, ontos = c("BP", "MF", "CC"), ontoLevels = c(2, 3),
  trace = TRUE, onTheFlyDev = NULL, method = "complete",
  jobName = "Equivalence clustering",
  ylab = "Equivalence threshold distance", alpha = 0.05, precis = 0.001,
  ...)
}
\arguments{
\item{geneLists}{list of character vectors, each vector stands for the gene names in a given gene set}

\item{ontos}{character vector, (e.g. c("BP","MF")) indicating the GO ontologies to be analysed}

\item{ontoLevels}{integer vector (e.g. 2:4) indicating the GO levels in these ontologies 
where the GO profiles are built}

\item{trace}{boolean, the full process must be traced? Defaults to TRUE}

\item{onTheFlyDev}{character, name of the graphical device where to immediately display the resulting
diagrams. The appropriate names depend on the operating system. Defaults to \code{NULL} and then
nothing is displayed. Otherwise, successive graphical windows are opened and the successive diagrams
are displayed in them}

\item{method}{character, one of the admissible methods in function \code{hclust}. Defaults to "complete"}

\item{jobName}{character, main plot name, defaults to "Equivalence clustering"}

\item{ylab}{character, label of the vertical axis of the plot, defaults to "Equivalence threshold distance"}

\item{alpha}{simultaneous nominal significance level for the equivalence tests to be repeteadly performed,
defaults to 0.05}

\item{precis}{numerical precission in the iterative search of the equivalence threshold distances,
defaults to 0.001}

\item{...}{additional arguments to \code{hclust}}
}
\value{
An object of class \code{iterEquivCluster}. It is a list of \code{length(ontos)},
  one element for each ontology under study. Each element of this list is itself a list of
  \code{length(ontoLevels)} with elements of class \code{equivClust}, standing for the cluster equivalence
  analysis performed for each ontology and level analysed
}
\description{
For each combination of the specified levels in the choosen GO ontologies, 
compute the equivalence threshold distance matrix and generate a dendrogram from it.
}
\examples{
\dontrun{
data(kidneyGeneLists)
kidneyGeneLists
genListsClusters <- iterEquivClust(kidneyGeneLists, ontoLevels = 2:3,
                                   jobName = "Kidney Gene Lists_Equivalence Clustering (complete)",
                                   ylab = "Equivalence threshold distance",
                                   orgPackage="org.Hs.eg.db", method = "complete")
genListsClusters[["BP"]][["Level 3"]]
class(genListsClusters[["BP"]][["Level 3"]])
}
}
